<?php
//Activates featured Image
add_theme_support( 'post-thumbnails' );
set_post_thumbnail_size( 150, 150 );
// Image size for single posts
//add_image_size( 'single-post-thumbnail', 620, 620 );
// deactivates admin bar
add_filter('show_admin_bar', '__return_false');

// zeigt weiterlesen beim Kurztext an
function new_excerpt_more($more) {
    global $post;
    return '... <a href="'. get_permalink($post->ID) . '">weiter lesen >></a>.';
}
add_filter('excerpt_more', 'new_excerpt_more');

//Default backend Image Link to Media file
function wpb_imagelink_setup() {
	$image_set = get_option( 'image_default_link_type' );
	
	if ($image_set !== 'file') {
		update_option('image_default_link_type', 'file');
	}
}
add_action('admin_init', 'wpb_imagelink_setup', 10);

//Default backend Gallery Link to Media file
function my_gallery_default_type_set_link( $settings ) {
    $settings['galleryDefaults']['link'] = 'file';
    return $settings;
}
add_filter( 'media_view_settings', 'my_gallery_default_type_set_link');

//insert floatbox






add_filter('post_gallery', 'my_post_gallery', 10, 2);
function my_post_gallery($output, $attr) {
    global $post;

    if (isset($attr['orderby'])) {
        $attr['orderby'] = sanitize_sql_orderby($attr['orderby']);
        if (!$attr['orderby'])
            unset($attr['orderby']);
    }

    extract(shortcode_atts(array(
        'order' => 'ASC',
        'orderby' => 'menu_order ID',
        'id' => $post->ID,
        'itemtag' => 'dl',
        'icontag' => 'dt',
        'captiontag' => 'dd',
        'columns' => 3,
        'size' => 'thumbnail',
        'include' => '',
        'exclude' => ''
    ), $attr));

    $id = intval($id);
    if ('RAND' == $order) $orderby = 'none';

    if (!empty($include)) {
        $include = preg_replace('/[^0-9,]+/', '', $include);
        $_attachments = get_posts(array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby));

        $attachments = array();
        foreach ($_attachments as $key => $val) {
            $attachments[$val->ID] = $_attachments[$key];
        }
    }

    if (empty($attachments)) return '';

    // Here's your actual output, you may customize it to your need
	$output = "<div class=\"slideshow-wrapper\">\n";
    $output .= "<div class=\"preloader\"></div>\n";
	$output .= "<div class=\"floatbox\" data-fb-options=\"group:group1\">\n";
    $output .= "<ul data-orbit>\n";

    // Now you loop through each attachment
    foreach ($attachments as $id => $attachment) {
        // Fetch the thumbnail (or full image, it's up to you)
        $img = wp_get_attachment_image_src($id, 'thumbnail');
		$img2 = wp_get_attachment_image_src($id, 'full');
//      $img = wp_get_attachment_image_src($id, 'my-custom-image-size');
//        $img = wp_get_attachment_image_src($id, 'full');

        $output .= "<li>\n";
//        $output .= "<img src=\"{$img[0]}\" width=\"{$img[1]}\" height=\"{$img[2]}\" alt=\"\" />\n";
		$output .= "<a href=\"{$img2[0]}\" title=\"Dusk Dip at Ao Nang\"><img src=\"{$img[0]}\" width=\"{$img[1]}\" height=\"{$img[2]}\" alt=\"\" /></a>\n";
        $output .= "</li>\n";
    }

    $output .= "</ul>\n";
    $output .= "</div>\n";
	$output .= "</div>\n";


    return $output;
}
?>